#   Cisco Secure Network Analytics: Optional Components & Enhanced Visibility

## Required Components (Recap)

- **Manager**: Centralized management and data correlation.
- **Flow Collector**: Collects, analyzes, and deduplicates flow data.
- **Flow Rate License**: Controls aggregate flow ingestion capacity.

---

## Optional Components

### Flow Sensor

- **Purpose**: Generates NetFlow/IPFIX data for devices that cannot natively do so.
- **Deployment**: Physical or virtual appliance (including Flow Sensor Virtual Edition for virtual environments).
- **Functions**:
    - Receives mirrored network traffic (e.g., via SPAN).
    - Provides Layer 7 application visibility and packet-level performance stats (e.g., RTT, SRT).
    - Recognizes and classifies application types (business, social, peer-to-peer, etc.).
    - Adds fields like URLs and X-Forward header info to flow records.
    - Uses deep packet inspection, including with encrypted/obfuscated protocols.

### Cisco Telemetry Broker

- **Purpose**: Ingests, transforms, and forwards telemetry from multiple sources to one or more destinations.
- **Supported Inputs**: NetFlow, IPFIX, sFlow, syslog, SNMP, AWS cloud sources.
- **Key Features**:
    - Detects and processes various telemetry protocols.
    - Replicates and distributes telemetry to different analytics tools (e.g., Secure Network Analytics, Splunk).
    - Reduces network bandwidth usage compared to multiple exporters.
- **Architecture**:
    - **Manager Node**: Virtual machine managing broker nodes, controls telemetry flow.
    - **Broker Node**: Physical/virtual, can be clustered for high availability.
    - Optimizes telemetry pipelines for hybrid cloud environments.

### Cisco Secure Client (AnyConnect) Network Visibility Module (NVM)

- **Purpose**: Provides endpoint and user visibility, both on-premises and remote.
- **Functions**:
    - Collects process-level info (e.g., process name, parent process).
    - Uses nvzFlow (extension of IPFIX) to export data.
    - Helps analysts determine which endpoint process initiated network flows.
- **Data Handling**:
    - NVM data now sent directly to Flow Collector (no Endpoint Concentrator needed since v7.3.2).

### Threat Feed License

- **Purpose**: Provides global threat intelligence (powered by Cisco Talos).
- **Functions**:
    - Adds intelligence on botnet C2, malware, and emerging threats.
    - Continuously updated for high-fidelity detection and response.

### Global Threat Alerts

- **Purpose**: Cloud-based analytics for anomaly and threat detection.
- **Functions**:
    - Analyzes 10+ billion web requests daily.
    - Uses machine learning to establish baselines and detect anomalies.

---

## Integration with Cisco Identity Services Engine (ISE)

- **Purpose**: Adds user and endpoint context to flow data via pxGrid integration.
- **Functions**:
    - Provides user identity and contextual info.
    - Allows mitigation requests from Secure Network Analytics to ISE for response actions.

---

# Flow Sensor Deep Dive

## Additional Capabilities

- **Performance Metrics**: RTT and SRT for application/network troubleshooting.
- **Application Visibility**: Classifies traffic by app type and variant.
- **URL Data**: Includes website and file path visibility in flow records.
- **Virtual Environments**: Flow Sensor VE installs inside each virtual host and connects to virtual switches.

---

# Cisco Telemetry Broker Deep Dive

## Key Features

- **Flexible Ingestion**: On-prem and cloud telemetry sources.
- **Efficient Distribution**: Replicates flows to multiple consumers without overloading network devices.
- **High Availability**: Broker nodes can be clustered.
- **Comprehensive Protocol Support**: Detects NetFlow, IPFIX, sFlow, syslog, and SNMP.

---

# Cisco Secure Network Analytics Use Cases & Deployment

## Visibility

- **Comprehensive**: Uses NetFlow/IPFIX data across access, distribution, core, data center, and edge.
- **Identity and Context**: Enhanced by integrating with ISE and TrustSec.

## Deployment Guidelines

- **Typical Locations**: Flow Collector and Manager in data center server farm; Data Store nodes if used.
- **NetFlow Enablement**:
    - Access layer for lateral (east-west) and north-south traffic visibility.
    - Distribution layer if not feasible at access layer.
    - WAN and internet edge routers.
    - Cisco Wireless LAN Controllers.
- **Additional Context**:
    - Enable NetFlow on firewalls for NAT, firewall action, and user data.
    - Use NBAR on routers/switches for Layer 7 visibility.
    - Use Flow Sensor where native NetFlow isn’t available or for additional application/URL/latency stats.

## Data Handling

- NetFlow is exported to Flow Collector for deduplication, stitching, and behavioral analytics.
- Data Store (if used): Central repository, data is segmented and backed up across Data Nodes.

## Customization

- NetFlow and flow data collection locations vary by use case (performance, security, monitoring).

---

**Summary:**  
Cisco Secure Network Analytics offers optional components—Flow Sensor, Telemetry Broker, Secure Client NVM, Threat Feed License, and Global Threat Alerts—to enhance network and endpoint visibility, enrich analytics, and strengthen threat detection. Integration with Cisco ISE adds user context, and flexible deployment guidelines allow for optimized flow collection and analytics across diverse network environments.